<?php
// Auto Load Classes
require_once("../../autoloader.php");

// Allowed API Headers
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST");
header("Allow: POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

$headers = apache_request_headers();
$response = array();
$controller = new Account;

date_default_timezone_set('Africa/Lagos');

// -------------------------------------------------------------------
//  Check Request Method
// -------------------------------------------------------------------



if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Read and decode JSON input as an object
    $input = file_get_contents('php://input');
    $data = json_decode($input); // Decode as an object

    // Access data using the arrow operator
    $fname = $data->firstname;
    $lname = $data->lastname;
    $phone = $data->phone;
    $email = $data->email;
    $pin = $data->pin;
    $dob = $data->dob;
    $accesspass = $data->password;
    $username = $data->username;
    $referal = $data->referral;

    

    $requiredField = "";

    if ($phone == "") {
        $requiredField .= "Phone Number Field Is Required. ";
    }
    if ($accesspass == "") {
        $requiredField .= "Password Field Is Required. ";
    }
     if ($pin == "") {
        $requiredField .= "Pin Field Is Required. ";
    }
    if (!is_numeric($phone)) {
        $requiredField .= "Please Enter A Valid Phone Number. ";
    }
    if (strlen($phone) != 11) {
        $requiredField .= "Please Enter A Valid Phone Number. ";
    }

    if ($requiredField !== "") {
        header('HTTP/1.0 200 Success');
        $data = array(
            "status" => "unauthorized",
            "status_msg" => $requiredField,
        );
        $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
        echo $jsonString;
        exit();
    }

    $result = $controller->registerUserFingerprint($username, $fname, $lname, $email, $phone, $accesspass,$referal,$pin,$dob);
    file_put_contents("Rejii.txt", json_encode($result, JSON_UNESCAPED_SLASHES));

    if ($result["status"] == "success") {
        header('HTTP/1.0 200 Success');
        $data = array(
            "status" => "success",
            "user_id" => $result["user_id"],
            "api_key" => $result["api_key"],
            "status_msg" => "Account Created Successfully",
        );
        $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
        echo $jsonString;
    } elseif ($result["status"] == "fail") {
        header('HTTP/1.0 200 Success');
        $data = array(
            "status" => "blocked",
            "status_msg" =>$result["msg"],
        );
        $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
        echo $jsonString;
        exit();
    } else {
        header('HTTP/1.0 200 Unauthorized');
         $data = array(
            "status" => "Unauthorized",
            "status_msg" => "blocked",
        );
        $jsonString = json_encode($data, JSON_UNESCAPED_SLASHES);
        echo $jsonString;
        exit();
    }
}
?>
