<?php
require_once("../../autoloader.php");
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST");
header("Allow: POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

$headers = apache_request_headers();
$response = array();
$controller = new SubscriberModel;

date_default_timezone_set('Africa/Lagos');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $vercode = $_POST['vercode'];
    $new = $_POST['new_password'];
    $userId = $_POST['user_id'];

    // Run password function
    $result = $controller->setUserNewPassword($userId, $vercode, $new);

    // 🔥 Log both input and result
    $logData = [
        'vercode' => $vercode,
        'new_password' => $new,
        'user_id' => $userId,
        'result' => $result,
        'timestamp' => date("Y-m-d H:i:s"),
    ];
    file_put_contents("airtime_fail_log.txt", json_encode($logData, JSON_UNESCAPED_SLASHES) . PHP_EOL, FILE_APPEND);

    // Process response
    if ($result != 0) {
        header('HTTP/1.0 400 Invalid Network Id');
        $response['status'] = "fail";
        $response['msg'] = "The Network id is invalid";
        echo json_encode($response);
        exit();
    } else {
        $response = array('status' => 'success', 'statusy' => $result);
        echo json_encode($response);
    }

} else {
    $response = array('status' => 'error', 'message' => 'Invalid request method');
    echo json_encode($response);
}
?>
