<?php
require_once("../../autoloader.php");
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST");
header("Allow: POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

$headers = apache_request_headers();
$response = array();
$controller = new SubscriberModel;

date_default_timezone_set('Africa/Lagos');

// Submit Query
if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_GET['action'] == 'storeQuery') {
    $sId = $_POST['sId'];
    $ref = $_POST['ref'];
    $heading = $_POST['heading'];
    $queryContent = $_POST['queryContent'];
    $controller->storeQuery($sId, $ref,$heading, $queryContent);
    echo json_encode(["message" => "Query submitted successfully"]);
}

// Submit Reply
if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_GET['action'] == 'storeReply') {
    $issueId = $_POST['issueId'];
    $replyContent = $_POST['replyContent'];
    $replyby = $_POST['replyby'];
    $image1 = $_POST['image'];
    $imageData = base64_decode($image1);
    $img = imagecreatefromstring($imageData);
            $imageFormat = 'png'; 
            if (imageistruecolor($img)) {
                $imageFormat = 'png';
            } else {
                $imageFormat = 'jpg';
            }
            $imageName = 'user_image_' . uniqid() . '.' . $imageFormat;
            $uploadDirectory = '/home2/wapaycom/new.wapay.com.ng/api/mobile/uploadimage/images/';
            if ($imageFormat === 'jpg') {
                imagejpeg($img, $uploadDirectory . $imageName);
            } else {
                imagepng($img, $uploadDirectory . $imageName); // Save as PNG by default
            }

            // Update the profile picture in the database with the image path
            $imagePath = 'https://new.wapay.com.ng/api/mobile/uploadimage/images/' . $imageName;
     $controller->storeReply($issueId, $replyContent, $replyby, $imagePath);
    echo json_encode(["message" => "Reply submitted successfully"]);
}


// Submit Reply
if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_GET['action'] == 'storeReplyText') {
    $issueId = $_POST['issueId'];
    $replyContent = $_POST['replyContent'];
    $replyby = $_POST['replyby'];
    $image = "";
   
     $controller->storeReply($issueId, $replyContent, $replyby, $image);
    echo json_encode(["message" => "Reply submitted successfully"]);
}

if ($_SERVER['REQUEST_METHOD'] == 'GET' && $_GET['action'] == 'getQueries') {
    $userId = $_GET['id'];
    $result =  $controller->getQueries($userId);
    echo json_encode($result);
}

// Get Queries and Replies
if ($_SERVER['REQUEST_METHOD'] == 'GET' && $_GET['action'] == 'getQueryAndReplies') {
    $issueId = $_GET['id'];
    $result =  $controller->getQueriesAndReplies($issueId);
    echo json_encode($result);
}

// Get Unread Count
if ($_SERVER['REQUEST_METHOD'] == 'GET' && $_GET['action'] == 'getUnread') {
    $userId = $_GET['id'];
    $result =  $controller->getUnread($userId);
    echo json_encode($result);
}
