<?php
require_once("../../autoloader.php");
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST");
header("Allow: POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Access-Control-Allow-Origin");

$headers = apache_request_headers();
$response = array();
$controller = new SubscriberModel;

date_default_timezone_set('Africa/Lagos');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if userId is provided in the POST request
    if (!isset($_POST['userId']) || empty($_POST['userId'])) {
        $response = [
            'status' => 'error',
            'message' => 'userId is required'
        ];
        echo json_encode($response);
        exit;
    }

    $userId = $_POST['userId'];
    
    // Optionally, fetch virtual account if needed
    $master = $controller->getVirtualAccount($userId);
    file_put_contents("master.txt", json_encode($master));

    // Fetch all notifications with status = 0
    $result = $controller->getNotifications();
    echo json_encode($result);
} else {
    $response = [
        'status' => 'error',
        'message' => 'Invalid request method. Only POST is allowed.'
    ];
    echo json_encode($response);
}
?>