<?php
// api_script.php
header('Content-Type: application/json');

require 'data.php'; // Include the public function script

// Get the raw POST data
$data = json_decode(file_get_contents('php://input'), true);

// Check if user_id is present in the request
if (!isset($data['user_id'])) {
    echo json_encode(['error' => 'User ID is required']);
    http_response_code(400);
    exit;
}

$user_id = $data['user_id'];

try {
    // Call the function to get the banks by status
    $result = get_banks_by_status($user_id);
    echo json_encode($result);
    http_response_code(200);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
    http_response_code(500);
}
