<?php

$host = 'localhost';
$db = 'wapaycom_update';
$user = 'wapaycom_update';
$pass = 'rtMO7!NLci#m';

function get_banks_by_status($user_id)
{
    global $host, $db, $user, $pass;

    $conn = new mysqli($host, $user, $pass, $db);

    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }
    $sql_status = "SELECT name, value FROM apiconfigs WHERE value = 'On'";
    $result_status = $conn->query($sql_status);

    if ($result_status->num_rows == 0) {
        return ["message" => "No banks are currently On."];
    }

    $active_banks = [];
    $status_map = [
        'monifyWeStatus' => 'sBankNo',
        'monifyFeStatus' => 'sFidelityBank',
        'monifyMoStatus' => 'sRolexBank',
        'monifySaStatus' => 'sSterlingBank',
        'payvesselStatus' => 'sPayVessel',
    ];

    while ($row = $result_status->fetch_assoc()) {
        $status_name = $row['name'];
        if (isset($status_map[$status_name])) {
            // Extract bank name from the status name
            $bank_column = $status_map[$status_name];
            $bank_name = strtolower(str_replace('s', '', $bank_column));
            $active_banks[$bank_name] = $status_name;
        }
    }

    if (empty($active_banks)) {
        return ["message" => "No banks are currently On."];
    }

    $sql_charges = "SELECT value FROM apiconfigs WHERE name = 'monifyCharges'";
    $result_charges = $conn->query($sql_charges);
    $charges = $result_charges->num_rows > 0 ? $result_charges->fetch_assoc()['value'] : '0';

    $columns = implode(',', array_values($status_map));
    $sql_banks_info = "SELECT sId, sFname, $columns FROM subscribers WHERE sId = ?";

    $stmt = $conn->prepare($sql_banks_info);
    $stmt->bind_param('s', $user_id);

    $stmt->execute();
    $result_banks_info = $stmt->get_result();

    // If no results, return message
    if ($result_banks_info->num_rows == 0) {
        return ["message" => "No banks found for this user."];
    }

    function get_image_url($bank_name)
    {
        $images = [
            'bankno' => 'https://dannvtu.com.ng/adsimages/wema.jpg',
            'fidelitybank' => 'https://dannvtu.com.ng/adsimages/fidelity.jpg',
            'rolexbank' => 'https://dannvtu.com.ng/adsimages/moniepoint1.jpg',
            'sterlingbank' => 'https://dannvtu.com.ng/adsimages/sterling.png',
            'payveel' => 'https://dannvtu.com.ng/adsimages/9psb.jpg',
            // Add other bank names and URLs as needed
        ];
        return isset($images[$bank_name]) ? $images[$bank_name] : 'https://example.com/default.png';
    }

    function get_real_bankname($bank_name)
    {
        $images = [
            'bankno' => 'Wema Bank',
            'fidelitybank' => 'Fidelity Bank',
            'rolexbank' => 'Moniepoint Bank',
            'sterlingbank' => 'Sterling Bank',
            'payveel' => '9PaymentService Bank',

        ];
        return isset($images[$bank_name]) ? $images[$bank_name] : 'bank name';
    }

    $banks_data = [];
    while ($bank = $result_banks_info->fetch_assoc()) {

        $account_name = 'Default Account Name';
        if (!empty($bank['sFname'])) {
            $fname = $bank['sFname'];
            $prefix = 'Wapay-';
            $formatted_name = strtoupper(substr($fname, 0, 3));
            $account_name = $prefix . $formatted_name;
        }

        foreach ($active_banks as $bank_name => $status_name) {
            $column_name = $status_map[$status_name];
            if (!empty($bank[$column_name])) {
                $banks_data[] = [
                    "bankname" => $bank_name,
                    "accountno" => $bank[$column_name],
                    "charges" => $charges,
                    "bank" => get_real_bankname($bank_name),
                    "imageurl" => get_image_url($bank_name),
                    "accountname" => $account_name, 
                ];
            }
        }
    }

    $stmt->close();
    $conn->close();

    return $banks_data;
}
