<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

require 'db.php';

$data = json_decode(file_get_contents("php://input"), true);

try {
    $sql = "UPDATE settings SET 
        maintenance = :maintenance,
        postutme_fee = :postutme_fee,
        whatsapp_url = :whatsapp_url,
        facebook_url = :facebook_url,
        email = :email,
        phone = :phone,
        home_notification_status = :home_notification_status,
        home_notification_subject = :home_notification_subject,
        home_notification_message = :home_notification_message
        WHERE id = 1";

    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':maintenance' => $data['maintenance'],
        ':postutme_fee' => $data['postutme_fee'],
        ':whatsapp_url' => $data['whatsapp_url'],
        ':facebook_url' => $data['facebook_url'],
        ':email' => $data['email'],
        ':phone' => $data['phone'],
        ':home_notification_status' => $data['home_notification_status'],
        ':home_notification_subject' => $data['home_notification_subject'],
        ':home_notification_message' => $data['home_notification_message'],
    ]);

    echo json_encode(['status' => 'success', 'message' => 'Settings updated successfully']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
